! "stamp" (cells 8920 length 338 width 510 generation 0)
! Oscillator collection
! A collection of 115 oscillators.  The names and discoverers of
! those in the first 4 columns are shown below.
!
! For some periods, the only known oscillators are obtained by
! combining sparks from lower period oscillators; some of these
! are shown in the last column.  (The p690 is also of this form,
! but the interaction is less trivial.)
!
! Other periods may be obtained by bouncing gliders between
! pentadecathlons, queen bee shuttles, twin bee shuttles, and
! centinals, or between the output streams of guns of periods
! 30, 44, 46, and 94.  In this way we obtain as periods all
! multiples of 30, 44, 46, 94, and 100, as well as all numbers
! of the form  75+60n  (n>=0).  In addition, all numbers of the
! forms  50+40n,  66+24n,  230+40n,  and  246+24n  (n>=0)  may
! be obtained using a 2-glider reflection due to Bob Wainwright.  
!
! We can obtain as periods all multiples of 8 which are >= 136 and
! all multiples of 5 which are >= 150 by a construction due to
! David Buckingham, in which B-heptominos travel around a track
! formed by p5 or p8 oscillators.
!
! I don't know who first discovered all of these oscillators, but
! what I do know (or believe) is listed below.  For brevity, the
! discoverers's names are abbreviated:
!
!      A  = Hickerson's Apple IIe search program
!      AT = Arthur Taber
!      B  = David Buckingham
!      C  = John Conway
!      DW = Don Woods
!      G  = Bill Gosper
!      GC = George Collins, Jr.
!      H  = Dean Hickerson
!      JK = Jan Kok
!      MN = Mark Niemiec
!      RS = Rich Schroeppel
!      SG = Sol Goodman
!      W  = Bob Wainwright
! 
! Per Disc  Name
! --- ----  ---------------------
!   3 A     caterer
!   3 A     jam
!   3 ?     2 eaters
!   3 W     eaters +
!   3 W     trice tongs
!   3 RS    MIT oscillator
!   3 A     ?
!   3 A     ?
!   3 W     ?
!   3 C     pulsar CP 48-56-72
!   4 A     mold
!   4 ?     mazing
!   4 A     monogram
!   4 A     ?
!   4 A     ?
!   4 A     ?
!   4 B     eater/block frob
!   4 B     confused eaters
!   4 W     HW emulator
!   4 A     ?
!   4 B     ?
!   4 C     pinwheel
!   4 ?     clock II
!   4 A     ?
!   4 W     T-nosed p4
!   5 A     fumarole
!   5 SG,AT octagon II
!   5 G     pentoad
!   5 W     ?
!   5 W     pentant
!   5 B     technician
!   5 B     mathematician
!   5 B     aVerage
!   5 A     toaster
!   5 A     MW volcano
!   6 ?     unix
!   6 B     extremely impressive
!   6 A     ?
!   6 A     ?
!   6 ?     ?
!   6 W     ?
!   6 A     ?
!   6 B     $rats
!   7 B     burloaferimeter
!   7 B     airforce
!   7 B     ?
!   7 B     ?
!   7 B     ?
!   7 B     ?
!   7 B     ?
!   8 W     blocker
!   8 C     figure 8
!   8 JK    Kok's galaxy
!   8 W,DW  cauldron/crucible
!   8 C     Hertz oscillator
!   8 W     ?
!   8 W     roteightor
!   8 B     ?
!   9 B     worker bee
!   9 MN    snacker
!   9 B     ?
!   9 B     ?
!   9 B     ?
!  10 B     ?
!  10 B     ?
!  10 B     ?
!  10 B     ?
!  11 B     ?
!  11 B     ?
!  12 W     dinner table
!  12 ?     baker's dozen
!  12 B,W   ?
!  13 B     ?
!  14 GC    tumbler
!  15 C     pentadecathlon
!  15 W     ?
!  16 W     sailboat
!  18 B     ?
!  26 B     ?
!  28 W     ?
!  28 W     ?
!  29 W     ?
!  29 W     ?
!  29 B     ?
!  30 ?     queen bee shuttle
!  30 B,W   Eureka
!  30 W     ?
!  32 B,W   gourmet
!  32 W     popover
!  32 W     pi portraitor
!  32 W     ?
!  36 G     p36 toadsucker
!  40 B     ?
!  44 B     ?
!  46 G     twin bees shuttle
!  47 B     ?
!  52 B     ?
!  54 B     p54 shuttle
!  55 B     ?
!  56 B     ?
!  60 W     twirling T-tetsons II
!  60 G     p36 toadsucker
!  72 W     ?
! 100 G     centinal
! 108 B     p108 toadsucker
! 128 B     ?
! 690 H     ?
!
! Compiled by Dean Hickerson (drhickerson@ucdavis.edu) 5/18/92
!
169k255h@!
6.OO.O11.OO11.OO14.OO9.OO6.O12.OO83.OO.OO55.OO.O6.OO.O23.O27.O14.O58.O25.O54.OO.O6.OO.O11.OO9.OO
6.O.OO13.O12.O13.O10.O7.3O6.OO.O.O82.O.O.O56.O.OO6.O.OO22.O.O25.O.O7.OO3.O.O56.O.O23.O.O53.O.OO6.O.OO10.O..O7.O..O
10.OO8.O12.O14.O.O7.OO.O5.OO3.O5.OO.O84.O3.O60.OO..OO4.OO19.O3.OO24.O7.3O4.O58.O25.O58.OO..OO4.OO8.3O..5O..3O
10.O9.O3.O8.O3.O10.OO7.O..O7.O.O.O8.O82.OO.3O61.O3.O5.O9.OO9.O3.OO3.OO28.OO68.O15.O63.O3.O5.O12.OO5.OO
11.O8.O3.4O5.O..O.O6.OO10.O10.O12.O..O78.O.O.O64.O3.O5.O8.OO9.O3.OO3.OO91.5O..3O11.3O..5O57.O3.O5.O10.O9.O
10.OO10.O12.O..O5.O.O12.O9.OO..O8.OO.O77.O.O.O63.OO..OO4.OO20.O.O97.O4.O5.O9.O5.O4.O55.OO..OO4.OO10.OO.O3.O.OO
6.OO.O26.OO6.O11.O..O12.OO11.O37.OO..OO32.OO..O61.OO.O4.O5.O22.O69.O.OO6.O.OO14.O..O7.OO9.OO7.O..O50.OO.O4.O5.O16.O
6.O.OO33.OO10.O.OO26.OO37.O3.O10.OO.OO16.O4.OO60.O.OO5.O5.O58.OO31.OO.O6.OO.O11.O..O.OO27.OO.O..O47.O.OO5.O5.O
10.OO43.O67.O3.O12.O.O.O15.5O10.OO54.OO..OO4.OO49.O7.3O4.O24.OO8.OO14.O.O.O5.O21.O5.O.O.O44.OO8.OO4.OO16.OO
10.O43.OO67.OO..OO11.O4.O12.OO4.O10.O55.O3.O5.O49.O.O7.OO3.O.O24.O9.O15.O..O4.O.O19.O.O4.O..O45.O9.O5.O15.O4.O
11.O125.OO.O5.O10.O..3O4.3O3.O.O56.O3.O5.O49.O14.O24.O9.O19.OO..O..O6.O5.O6.O..O..OO49.O9.O5.O14.O4.O
10.OO111.OO..OO8.OO.O6.O9.OO.O5.O3.O..OO56.OO..OO4.OO89.OO8.OO23.OO6.3O3.3O6.OO53.OO8.OO4.OO14.O4.O
6.OO.O61.3O3.3O44.O3.O11.O.O5.O11.O4.O5.O7.O47.OO.O6.OO.O93.O.OO6.O.OO99.OO.O6.OO.O17.O..O
6.O.OO15.O32.4O61.O3.O12.O.OO3.OO8.3O5.O5.O5.3O47.O.OO6.O.OO93.OO.O6.OO.O99.O.OO6.O.OO15.O.O..O.O
21.O.OO.O.OO28.O..O7.O4.O.O4.O41.OO..OO12.O15.O7.O5.O4.O161.OO8.OO126.OO4.OO
20.O.O3.O.OO10.O15.3O..3O5.O4.O.O4.O60.7O13.OO..O3.O5.O.OO159.O9.O17.OO21.OO
21.O4.O13.3O3.O.3O5.O6.O5.O4.O.O4.O41.OO..OO19.O12.O.O3.3O4.3O..O158.O9.O13.OO..O..O19.O..O..OO
25.OO12.O.O3.O.O8.O6.O7.3O3.3O44.O3.O15.OO15.O10.O4.OO159.OO8.OO9.O..O4.O.O19.O.O4.O..O
36.3O.O3.3O9.3O..3O59.O3.O16.OO14.OO10.5O157.O.OO6.O.OO10.O.O.O5.O21.O5.O.O.O
46.O11.O..O9.3O3.3O43.OO..OO41.OO4.O157.OO.O6.OO.O11.O..O.OO27.OO.O..O
58.4O7.O4.O.O4.O89.O..OO75.O..O.OO.O..O11.O..O.OO.O..O76.O..O27.O..O
69.O4.O.O4.O87.O.O.O77.4O.OO.4O11.4O.OO.4O77.O4.O3.OO11.OO3.O4.O
69.O4.O.O4.O87.O.O.O77.O..O.OO.O..O3.OO.OO3.O..O.OO.O..O78.5O4.O11.O4.5O
167.3O.OO93.OO.OO100.O.O.O7.O.O.O
71.3O3.3O86.O3.O195.O3.O.O.OO7.OO.O.O3.O
166.O.O.O194.O.O..O.O13.O.O..O.O81.O8.O
165.OO.OO196.O4.OO13.OO4.O60.OO.O4.OO11.O.O6.OO
453.O.OO.....O...........O.O
453.....OO..O.........OO.O.OO...OOO..O.O
453.....O...OO........O.OO....O...O.OOOO
453......O................OOO.O.......OO
453.....OO..OO............O
453.OO.O.....O.............OOO..OO
453.O.OO....O.................O
301.O149.OO8.OO13.OO.O.O.O
301.O149.O24.OO.O.O.3O
5.OO3.OO45.O.O9.O.O229.3O148.O8.OO17.OO4.O
5.OO3.OO21.O23.O.O.OO6.O..O15.O.O..O.3O19.OO4.OO.O59.OO18.OO85.OO7.OO86.OO.OO.O54.OO9.O19.4O
22.O.O7.O.O20.OO4.O10.O14.O..O.O.O.O21.O4.O.OO11.O17.OO9.OO16.O.O18.O.O84.OO..3O..OO85.OO..OO.OO55.OO.O4.O20.O
5.OO3.OO13.O17.OO3.OO9.3O9.3O..3O8.O29.O9.OO9.3O7.OO6.4O.O5.OO16.O.O.OO12.OO.O.O52.OO36.3O95.O55.O.OO4.OO20.O
5.O.O.O.O9.O..O6.OO3.O7.O.O.O6.OO.O..O6.3O..3O18.O22.OO8.O13.O6.O7.O.O..3O22.O.O.O12.O.O.O53.O37.3O32.O.OO6.OO.O24.OO15.OO91.OO
7.O.O10.O.O.O6.O5.O6.OO.OO9.O..O12.O10.O.O.O.O..O33.O11.OO4.O.O39.O16.O47.O.OO.OO.O5.OO25.OO38.OO.O6.O.OO24.OO15.OO5.OO
6.OO.O10.O..O10.O.O7.O.O.O7.5O13.O..O6.3O.O..O.O23.OO8.OO17.OO12.OO4.OO19.O..O13.O..O45.OO.O.O.O6.O14.3O8.O..O35.OO8.OO52.OO
10.OO9.OO10.OO8.OO3.OO6.O18.O.O40.O4.OO.O16.OO15.O4.O..O5.O12.O5.OO3.O5.O54.O8.O13.3O8.O.O37.O8.O46.O
11.O105.O5.O.OO16.OO21.O.O4.OO12.O3.O.3O.OO5.O3.O18.OO.O6.OO.O26.OO11.3O..OO3.O3.O4.3O30.O10.O45.OO.OO..OO
10.O106.OO..OO20.OO22.O19.O5.OO3.O5.O22.O.OO6.O.OO44.OO3.O41.OO8.OO17.O..O17.OO.O4.O.OO.OO
10.OO109.O17.OO30.3O..O.O8.O..O13.O..O23.OO8.OO24.OO15.3O3.O43.O.OO6.OO.O17.O16.O3.O
11.O105.OO3.O15.O.O4.OO19.OO5.O.4O9.O16.O25.O9.O9.O9.3O..O.O15.O17.OO3.OO25.OO.O6.O.OO18.OO15.3O
10.O107.O..OO15.O6.O20.OO9.OO7.O.O.O12.O.O.O24.O9.O8.3O7.O.O3.O16.O11.3O..O..O..OO29.OO..OO4.OO10.O.OO6.O
10.OO9.OO12.O23.OO56.O5.OO.O10.OO7.3O36.O.O.OO12.OO.O.O22.OO8.OO11.O6.O.O4.3O17.O7.O.O3.O.O34.O..O5.O11.O..O3.O
22.O12.3O16.OO.O4.O.OO7.OO8.OO9.OO21.OO4.O.OO21.O36.O.O18.O.O18.OO.O6.OO.O12.O.O14.O16.O.O6.O.O4.O34.O4.O5.O9.O3.O.3O
22.O.O13.O15.O10.O7.OO.OO..OO.OO9.O.O89.OO18.OO19.O.OO6.O.OO12.OO28.OO..O..O16.O30.OO..OO4.OO8.O11.O13.OO62.OO.O4.OO3.OO
23.O.O11.O17.OO6.OO9.O..O..O..O12.O..O131.OO..OO46.OO3.OO17.O26.O.OO6.OO.O13.3O.O3.O14.OO62.O.OO4.OO3.OO9.O..O
25.OO.OO7.O..O11.3O..6O..3O6.OO.4O.OO11.OO.O.O130.O3.O17.OO46.O3.3O26.OO.O6.O.OO13.O3.O..O83.OO21.O
28.OO10.O11.O..O8.O..O26.O.O..O132.O3.O16.O8.O38.O3.OO51.O6.OO.O83.O3.OO3.OO8.O4.O10.OO
22.OO14.O.O12.OO10.OO22.OO3.O.O134.OO..OO17.O6.O.O.O.OO21.3O8.O3.OO..3O49.OO90.O..O.O.O.O8.OO..O.O
23.O14.OO..OO45.O5.O131.OO.O6.OO.O12.OO5.O.OO.OO.O28.OO8.3O53.O88.OO4.O.O15.O.OO6.O3.O
20.3O19.O.O45.5O132.O.OO6.O.OO19.O35.O..O7.3O54.O..O80.OO.O5.OO.O24.O4.O
20.O23.O214.OO35.O.O149.O.OO9.OO21.O.O.O
44.OO46.O197.3O4.O148.OO14.O13.O..O3.O.O.O
63.3O25.O.O196.3O153.O14.O14.OO3.O4.O
60.OO.OO27.O195.OO..3O..OO148.O13.OO18.O3.O
60.OO.OO54.OO..OO.O14.O15.O130.OO7.OO147.OO14.O
61.O19.O38.O..O.OO13.O.O13.O.O129.3O157.OO.O9.O21.OO
81.O37.O7.OO11.O.O13.O.O131.O157.O.OO9.OO
26.OO15.OO8.OO25.3O36.OO6.O10.3O.OO11.OO.3O129.O
26.OO15.OO8.OO.OO3.O66.O8.O23.O
54.O..O..OO.4O.OO49.OO6.OO9.3O.OO11.OO.3O101.OO
24.4O13.4O9.OO.4O.OO..O..O50.O..OO.O13.O.OO11.OO.O98.OO.O4.O.OO96.O5.O
20.OO.O4.O8.OO.O4.O16.O3.OO.OO8.5O35.O3.O.OO20.O3.O105.O10.O96.OO3.OO25.OO
20.OO.OO3.O8.OO.O..O.O23.OO7.O.3O.O34.OO6.OO19.O.O107.OO6.OO97.OO3.OO23.O4.O
23.O..O.O.OO8.O..O.O.OO29.O.O.O.O42.O19.OO.OO103.3O..6O..3O35.OO58.O3.O23.O6.O
23.O.O..O.OO8.O.O..O.OO13.O14.OO.O.O.OO33.OO7.O16.O..O.O..O101.O..O8.O..O35.O86.O8.O
24.4O13.4O14.OO.OO12.O..OO.OO..O33.O6.OO15.O.O.O.O.O.O97.OO.O.O10.O.O.OO24.O.OO.OO.O5.OO20.OO.O6.OO.O45.O8.O
59.OO.OO12.OO7.OO32.O3.OO.O17.OO..O.O..OO97.O.O.O12.O.O.O17.OO5.OO.O.O.O6.O21.O.OO6.O.OO32.O12.O8.O
24.OO15.OO15.3O58.OO..O.OO21.O.O103.O16.O19.O12.O8.O18.OO8.OO4.OO28.O..O12.O6.O85.O6.OO
24.OO15.OO106.O102.O..O14.O..O9.O.OO.OO.O20.OO18.O9.O5.O29.O..O13.O4.O46.OO.O6.O.OO25.O.O.OO..O
255.O7.3O4.O12.OO.O.O.O42.O9.O5.O9.O8.O5.O4.O17.OO48.O.OO6.OO.O14.O10.O.O.O.O.O
251.O3.O7.O.O4.O3.O14.O4.3O15.OO18.OO8.OO4.OO8.O..O5.OO5.OO75.OO..OO17.O.O8.OO.O3.O.OO
251.O3.O7.O.O4.O3.O31.3O..O.O20.OO.O4.O5.O9.O..O6.O5.O4.O19.O51.O4.O17.O.O8.O..OO.OO..O
255.O14.O35.O.O3.O21.O.OO5.O5.O10.O17.O..O15.O..O51.O..O15.OO.O.OO8.O7.O
252.O..O14.O..O23.OO7.O.O4.3O16.OO4.OO..OO4.OO28.O..O15.O..O50.OO..OO14.O.OO11.O7.O
254.O16.O9.O9.3O..O..O15.O16.O5.O3.O5.O11.O19.O17.O48.OO.O6.O.OO14.OO.O6.O..OO.OO..O
252.O.O.O12.O.O.O7.3O7.O.O3.O.O33.O5.O3.O5.O8.O..O85.O.OO6.OO.O14.O6.O..OO.O3.O.OO
252.OO.O.O10.O.O.OO10.O6.O.O4.O33.OO4.OO..OO4.OO8.O..O34.OO53.OO8.OO13.3O7.O.O.O.O.O
255.O..O8.O..O12.O.O48.OO.O6.OO.O11.O34.O4.O51.O10.O16.O.O4.O.O.OO..O
255.3O..6O..3O12.OO15.3O4.O26.O.OO6.O.OO45.O6.O51.O8.O14.OO.O3.O3.O6.OO
6.O.OO44.OO62.OO..OO3.OO129.OO6.OO38.O.O.O.OO78.O8.O49.OO8.OO13.OO.O.O.4O
6.OO.O44.O10.OO8.OO42.O..OO3.OO128.O10.O14.OO20.O.OO.OO.O55.O3.O18.O8.O45.OO.O6.O.OO19.OO
4.OO29.OO15.O.O9.O.O9.O41.O138.OO.O4.O.OO14.O8.O12.O62.OO3.OO17.O8.O45.O.OO6.OO.O21.3O
5.O17.OO9.O..O14.OO7.O..O.OO8.O.O39.OO..OO3.OO133.OO20.O6.O.O.O.OO5.OO62.OO3.OO18.O6.O81.O..O
4.O16.O4.O6.O4.O9.OO10.O.O.O3.O8.OO4.OO37.O.O.O.O9.OO.OO140.OO5.O.OO.OO.O69.O5.O19.O4.O84.OO
4.OO15.O4.O5.O6.O9.O11.O..O3.3O13.O33.OO4.O.O11.OO.OO147.O105.OO
6.O.OO11.O4.O5.O6.O9.O14.O5.O9.4O35.O3.OO.O12.O.O147.OO
6.OO.O12.O..O7.O4.O10.OO14.5O10.O37.O8.OO8.O.O.O.O
10.OO8.O.O..O.O6.O..O7.OO30.O3.3O34.OO8.O8.O.O.O.O
11.O8.OO4.OO7.OO7.O.O20.O9.4O..O43.O9.OO3.OO
10.O33.O21.O.O11.O37.OO7.OO
10.OO31.OO22.O11.O39.O8.O
6.O.OO69.OO37.O8.O
6.OO.O108.OO7.OO
.
334.O.OO6.OO.O28.O110.O..O
334.OO.O6.O.OO27.O.OO108.O
39.O13.O13.O..O181.OO16.OO66.OO8.OO25.O.OO67.OO3.OO4.OO.O14.O10.O4.O
25.O12.O.O11.O.O29.O168.O7.OO7.O68.O8.O27.OO68.OO3.OO4.O.OO13.O.O8.O.O..OO
24.O.O11.O.O12.O12.O4.O10.O3.O166.O.O3.O4.O3.O.O67.O10.O111.OO11.O.O6.OO.O
24.OO11.OO.OO22.3O.OO.3O180.OO..O6.O..OO68.OO8.OO15.OO12.OO65.OO3.OO8.O9.OO.O.OO
22.OO11.O7.O7.5O7.O3.O..O3.O6.O5.O169.O8.O69.OO6.OO.O17.OO12.OO65.O.O.O.O9.O8.O.OO4.O
21.O3.3O7.3O3.3O6.O..O..O7.4O..4O5.3O.3O.3O167.O8.O70.O6.O.OO100.O.O10.OO12.3O.O3.O..O
20.O..OO3.O.O18.O.OO.OO.O20.O3.OO.OO3.O65.O4.O65.OO.O6.OO.O16.O8.O69.O5.OO103.OO.O6.OO.O14.O9.OO
21.OO4.O.OO4.9O5.O.O3.O.O6.OO.O..O.OO4.O.3O.O.4O27.OO4.O.OO27.OO.4O.OO63.O.OO6.O.OO13.OO..O6.O..OO66.OO4.O21.O.O84.OO4.O.OO15.3O..OO
23.O.O.O7.O7.O4.OO.O3.O.OO5.O8.O5.O38.O4.OO.O29.O4.O69.OO..OO16.O.O3.O4.O3.O.O63.OO7.O19.O18.OO68.O..OO22.O
23.O3.O10.4O6.O..O.O.O..O6.3O..3O8.O.O.O.OO.O26.O3.OO108.O3.O17.O7.OO7.O64.O6.OO14.OO..O4.O10.OO.O..O.OO63.O3.O20.OO.O.O.O
24.3O11.O..OO7.O5.O10.O..O9.OO.3O.O.OO26.OO3.O109.O3.O15.OO16.OO62.O9.OO.O10.OO.O..O.OO10.OO..O4.O63.OO3.O19.OO.O.O.3O
26.O.O22.5O7.4O.OO.4O6.O.O..O34.O109.OO..OO26.O70.OO8.O.OO14.OO19.O68.O..OO23.OO4.O
27.OO24.O9.O..O4.O..O6.O..OO31.OO..OO16.O4.O82.OO.O6.OO.O20.O..O119.O.O64.O5.OO.O21.4O
80.OO36.O4.O.OO10.OO.4O.OO12.OO..OO62.O.OO6.O.OO20.O..O186.OO4.O.OO21.O
67.O..O46.O5.OO.O12.O4.O14.OO..OO66.OO..OO4.OO19.O220.O
117.OO8.OO102.O3.O5.O9.OO16.OO211.OO
128.O103.O3.O5.O9.O7.OO7.O
117.OO8.O103.OO..OO4.OO9.O.O3.O4.O3.O.O
118.O8.OO98.OO.O6.OO.O12.OO..O6.O..OO
117.O5.O.OO27.OO3.O..O3.OO59.O.OO6.O.OO15.O8.O
117.OO4.OO.O27.5O4.5O88.O8.O
154.OO3.O..O3.OO88.O8.O
253.OO..O6.O..OO89.OO48.OO
252.O.O3.O4.O3.O.O58.OO4.OO.O6.OO.O11.O48.O
252.O7.OO7.O59.O4.O.OO6.O.OO11.O.O21.OO21.O.O
6.OO.O11.OO14.OO212.OO16.OO57.O3.OO4.OO..OO4.OO10.OO8.O12.OO12.OO7.OO
6.O.OO11.OO13.O.3O287.OO..O5.O3.O5.O20.OO26.O.O79.OO
4.OO30.O4.O18.O21.O4.O245.O5.O3.O5.O18.OO29.O77.O4.O
4.O16.O11.OO.O3.OO18.O19.O..O3.OO239.OO..OO4.OO..OO4.OO19.OO..OO22.3O76.O6.O
5.O14.O.O10.OO.O5.OO7.OO.OO4.O..O..O10.O.O3.O.O.3O4.O234.O..O5.O3.O5.O97.OO3.OO4.O.OO14.O8.O
4.OO14.O..O..OO9.5O..O5.O6.OO3.OO..4O6.3O4.O4.O..O3.O232.O4.O5.O3.O5.O96.OO3.OO4.OO.O14.O8.O
6.OO.O14.O.OO15.OO6.4O..OO3.OO6.O4.O3.O..O4.O4.3O233.OO..OO4.OO..OO4.OO105.OO18.O8.O
6.O.OO12.OO15.O14.O..O..O4.OO.OO6.O4.3O.O.O3.O.O51.O11.O174.O5.O3.O5.O20.OO..OO22.3O46.OO3.OO3.O19.O6.O
4.OO4.OO26.O.O19.O21.OO3.O..O53.O.O9.O.O169.OO3.O5.O3.O5.O18.OO29.O46.O.O.O.O..O21.O4.O
4.O5.O28.O20.O22.O4.O56.O11.O171.O..OO4.OO..OO4.OO19.OO26.O.O48.O.O4.OO22.OO
5.O5.O316.O5.OO.O6.OO.O12.OO8.O12.OO12.OO7.OO39.OO.O6.O.OO10.OO16.OO
4.OO4.OO131.5O7.5O92.OO20.OO52.OO4.O.OO6.O.OO11.O.O21.OO21.O.O42.OO4.OO.O11.O7.OO7.O
6.OO.O14.O7.O84.OO4.OO.O15.O4.O7.O4.O90.O..O19.OO83.O48.O43.O8.OO9.O.O3.O4.O3.O.O
6.O.OO13.O.O5.O.O84.O4.O.OO14.O..O13.O..O89.O106.OO48.OO41.O10.O10.OO..O6.O..OO
23.O.O5.O.O83.O3.OO15.O..O.OO13.OO.O..O86.O199.OO8.O14.O8.O
21.3O.OO3.OO.3O6.3O10.3O8.OO.OO10.OO34.OO..O15.O.O.O5.O7.O5.O.O.O85.O.OO20.OO175.O8.OO13.O8.O
20.O15.O6.3O..O..O..3O10.O.OO11.O39.O15.O..O4.O.O5.O.O4.O..O61.OO3.OO4.OO.O12.OO18.O.OO174.O5.O.OO15.O8.O
21.4O5.OO.3O11.O4.O11.OO14.O36.OO..OO18.OO..O..O5.O..O..OO64.OO3.OO4.O.OO32.O177.OO4.OO.O12.OO..O6.O..OO
23.O.OO3.OO.O13.O4.O14.O.OO5.OO.O.4O33.O4.OO.O19.OO7.OO78.OO4.OO30.O198.O.O3.O4.O3.O.O
47.O4.O10.O3.O..O5.OO.O5.O.O29.O5.O.OO23.OO74.OO3.OO..O5.O10.OO13.OO4.O..O195.O7.OO7.O
28.OO13.3O..O..O..3O9.OO.O9.O..3O.OO29.OO..OO4.OO21.O.O73.O.O.O.O3.O5.O9.OO12.O..O4.OO195.OO16.OO
28.O13.3O10.3O6.O14.O4.O36.O5.O17.O..O..O76.O.O4.OO4.OO23.O..O
28.O33.O.O15.3O.O32.OO3.O5.O15.O82.OO.O4.O5.O23.OO.OO
27.OO33.OO19.O34.O..OO4.OO13.OO10.3O74.OO3.O5.O23.OO
82.O34.O5.OO.O12.O6.OO.O4.3O75.O..OO4.OO116.OO25.OO
23.O.OO3.OO.O48.OO33.OO4.O.OO15.O3.O..O4.3O74.O3.O5.O16.O10.O90.O25.O
21.3O.OO5.4O106.3O.O3.O6.3O71.OO3.O5.O14.O.O8.O.O89.O.O9.OO10.O.O
20.O15.O102.O11.O5.3O72.O..OO4.OO15.O4.OO4.O91.OO7.O4.3O6.OO
21.3O.OO3.OO.3O104.O3.O.3O8.3O71.O5.OO.O20.O4.O101.OO6.3O
23.O.O5.O.O107.O..O3.O82.OO4.O.OO20.O4.O101.O8.O.O
23.O.O5.O.O107.O.OO6.O109.O4.O101.O8.O.O
24.O7.O114.OO113.O..O103.O3.6O96.O
146.O113.O.O..O.O173.OO4.OO.O6.O.OO13.O.O
142.O..O114.OO4.OO101.O3.6O63.O4.O.OO6.OO.O13.O.O6.O..O4.O..O
368.O8.O.O61.O3.OO4.OO..OO14.OO.O.OO3.3O..6O..3O
328.OO4.OO.O6.OO.O20.O8.O.O61.OO..O5.O4.O14.O.OO4.O3.O..O4.O..O
329.O4.O.OO6.O.OO20.OO6.3O67.O5.O..O19.3O.O
328.O3.OO4.OO..OO4.OO11.OO7.O4.3O6.OO55.OO..OO4.OO..OO18.O
328.OO..O5.O3.O5.O11.O.O9.OO10.O.O55.O..O5.O5.O.OO15.3O..OO
333.O5.O3.O5.O10.O25.O54.O4.O5.O4.OO.O18.O
328.OO..OO4.OO..OO4.OO9.OO13.O11.OO53.OO..OO4.OO8.OO13.OO.O.O.O
329.O..O5.O5.OO.O24.O..O69.O5.O10.O13.OO.O.O.3O
41.OO285.O4.O5.O4.O.OO24.O..O65.OO3.O5.O8.O18.OO4.O
41.OO18.OO265.OO..OO4.OO..OO4.OO8.OO13.O11.OO55.O..OO4.OO8.OO19.4O
61.O75.OO129.OO6.OO54.O5.O3.O5.O10.O25.O55.O5.OO.O6.O.OO21.O
6.O.OO15.O15.4O17.O14.O9.O50.O27.OO100.OO6.OO50.OO3.O5.O3.O5.O9.O.O9.OO10.O.O55.OO4.O.OO6.OO.O22.O
6.OO.O14.O.O13.O4.O13.3O.O.OO9.O.O7.O.O49.O.O25.O162.O..OO4.OO..OO4.OO10.OO7.O4.3O6.OO97.OO
10.OO11.O.O.O9.O..O3.O.O11.O..O.O.O..O7.O.O7.O.O50.OO23.O.O161.O5.OO.O6.OO.O19.OO6.3O
11.O11.O.O.O8.O.O.O.O.O.O..O9.3O.O.O.OO4.OO.O.OO5.OO.O.OO51.O.O..O.O13.OO162.OO4.O.OO6.O.OO19.O8.O.O
10.O9.OO.O3.O.OO6.O..O.O.O.O.O.O5.3O4.O.O7.O.OO..O5.O..OO.O50.O..O..O..O..O.O..O.O205.O8.O.O
10.OO8.O.O4.O.OO9.O.O3.O..O6.O..O.O.O.O11.OO7.OO55.O.O..O.O..O..O..O..O205.O3.6O4.OO
8.OO13.4O14.O4.O12.O4.O12.O..O3.O..O51.OO13.O.O..O.O90.OO38.OO
9.O32.4O14.4O14.3O3.3O30.OO4.OO.O11.O.O23.OO61.OO3.OO..OO3.OO8.O.O38.O.O73.O3.6O4.OO
8.O16.OO91.O4.O.OO11.O25.O.O60.OO3.OO..OO3.OO8.O.O.OO3.OO22.OO3.OO.O.O72.O8.O.O
8.OO15.OO17.OO16.OO13.O.OO3.OO.O29.O3.OO4.OO8.OO27.O85.O.O.O3.OO22.OO3.O.O.O73.O8.O.O
6.OO36.OO16.OO13.OO.O3.O.OO29.OO..O5.O38.OO59.OO3.OO..OO3.OO11.O36.O75.OO6.3O
7.O114.O5.O22.OO74.O.O.O.O..O.O.O.O10.O..O32.O..O67.OO7.O4.3O6.OO
6.O110.OO..OO4.OO22.OO..OO72.O.O6.O.O12.O15.OO4.OO15.O66.O.O9.OO10.O.O104.O7.O
6.OO110.O4.OO.O29.OO70.OO.O5.OO.O12.O3.O10.O.O4.O.O10.O3.O66.O25.O103.O.O5.O.O
117.O5.O.OO29.O75.OO7.OO10.O3.O9.OO8.OO9.O3.O65.OO25.OO103.O7.O
117.OO..OO4.OO31.OO71.O8.O10.O14.O.O4.O.O14.O
121.O5.O32.OO70.O8.O11.O..O12.OO4.OO12.O..O
117.OO3.O5.O16.OO85.OO7.OO11.O36.O
118.O..OO4.OO17.O27.OO57.O8.O9.O.O.O32.O.O.O189.O.O17.O.O
117.O5.OO.O19.O.O25.O57.O8.O9.O.O.OO32.OO.O.O191.O15.O
24.O44.OO7.OO37.OO4.O.OO20.OO23.O.O57.OO7.OO8.O.O38.O.O190.O4.O7.O4.O
23.O.O22.O..O17.OO7.OO71.O.O..O.O13.OO78.OO38.OO187.O7.O..O3.O..O7.O
23.O.O22.4O98.O..O..O..O..O.O..O.O267.OO.O6.OO.O6.OO.O19.O.OO6.3O3.3O6.OO.O
20.OO.O.OO42.4O3.4O71.O.O..O.O..O..O..O..O266.O.OO6.O.OO6.O.OO19.O9.3O3.3O9.O
20.O.OO22.8O14.O4.O.O4.O66.OO13.O.O..O.O271.OO8.OO..OO4.OO16.OO27.OO
24.OO19.O8.O12.O.O..OO.OO..O.O64.O.O23.OO222.O44.O9.O3.O5.O
24.O..O16.O.3O3.OO.O8.O..O.O9.O.O..O61.O25.O.O220.O.O44.O9.O3.O5.O23.OO13.OO
25.3O16.O.O6.O.O7.O.O.O.O..OO.OO..O.O.O.O59.OO27.O219.O3.O42.OO8.OO..OO4.OO23.OO13.OO
28.OO11.OO.O.O8.O.OO5.O..O.O9.O.O..O89.OO92.OO6.OO117.O3.O37.OO.O6.OO.O6.OO.O
25.OO.O3.O9.O.O10.O.O9.O.O..OO.OO..O.O186.OO6.OO118.O3.O36.O.OO6.O.OO6.O.OO18.OO27.OO
25.OO.O.O.3O7.O.O10.O.O10.O4.O.O4.O294.O.OO.OO15.O3.O39.OO..OO14.OO12.O4.O9.3O3.3O9.O
29.OO4.O5.OO.O8.O.O.OO10.4O3.4O294.OO.OO..OO15.O.O40.O3.O15.O12.O.O3.O.OO6.3O3.3O6.OO.O
31.4O9.O.O6.O.O318.O24.O42.O3.O15.O11.O.O4.O7.O..O3.O..O7.O
31.O12.O.OO3.3O.O13.OO7.OO301.OO58.OO..OO14.OO8.OO.O.OO7.O4.O7.O4.O
32.O12.O8.O14.OO7.OO294.OO5.OO54.OO.O6.OO.O6.OO.O10.O.OO4.O6.O15.O
31.OO13.8O320.OO61.O.OO6.O.OO6.O.OO14.3O.O3.O.O17.O.O
382.O92.O
48.4O322.OO..OO.OO93.3O..OO
48.O..O323.OO.OO.O97.O
153.OO3.OO316.OO.O.O.O6.O7.O
152.O..O.O..O65.OO3.OO4.OO.O235.OO.O.O.3O3.O.O5.O.O
148.OO3.OO3.OO3.OO61.OO3.OO4.O.OO34.O132.O.OO.OO65.OO4.O3.O7.O
148.O15.O70.OO24.OO9.OO3.O129.OO.OO..OO66.4O
145.OO.O15.O.OO58.OO3.OO..O24.O.O9.OO.O.OO92.OO34.O74.O
144.O.O.OO13.OO.O.O57.O.O.O.O3.O23.O10.O6.OO83.O6.3O10.O.OO27.OO67.O
144.O.O19.O.O59.O.O4.OO23.3O9.OO.O.OO83.O.O6.OO10.O3.O.O17.OO5.OO66.OO
142.OO..O19.O..OO56.OO.O6.OO.O31.OO3.O83.O3.O6.O7.OO7.O17.OO
141.O4.OO5.O5.O5.OO4.O59.OO4.O.OO34.O84.O3.O8.OO6.O5.O.O25.O
141.5O6.O.O3.O.O6.5O60.O..OO4.OO116.O3.O10.O5.O.OO.O21.OO..OO.OO
6.OO.O33.O..O16.O14.O.OO63.O21.O63.O3.O5.O18.3O95.O3.O45.OO.OO.O
6.O.OO37.O14.O.O13.OO.O57.4O9.3O3.3O9.4O57.OO3.O5.O8.OO7.O17.OO48.OO4.OO.O6.OO.O11.O.O
4.OO4.OO9.OO25.OO13.O75.O..O27.O..O58.O..OO4.OO8.OO7.O.O15.OO49.O4.O.OO6.O.OO12.O
4.O5.O10.OO19.O.OO6.O25.3O32.OO.O6.OO.O104.O5.OO.O20.OO65.O9.OO..OO4.OO
5.O5.O20.3O7.O..O3.O11.5O8.OO.O.O.O.OO28.O.OO6.O.OO26.OO3.OO71.OO4.O.OO87.OO8.O3.O5.O
4.OO4.OO20.3O6.O3.O.3O8.O.O5.O.O5.OO.O3.O.OO32.OO..OO15.O7.O.O5.O3.O5.O.O7.O164.O3.O5.O
6.OO.O10.OO10.3O5.O11.O5.OO.O3.O.OO8.O3.O35.O3.O15.O.O5.O..O..O9.O..O..O5.O.O152.OO8.OO..OO4.OO21.OO
6.O.OO10.OO.O5.3O11.3O.O3.O9.O3.O11.O3.O36.O3.O14.O.O6.O.O..OO7.OO..O.O6.O.O153.O4.OO.O6.OO.O23.OO33.OO
4.OO4.OO11.O5.3O11.O3.O..O10.O3.O12.3O36.OO..OO15.O35.O153.O5.O.OO6.O.OO58.OO
4.O5.O12.O5.3O8.O6.OO.O11.3O48.OO.O6.OO.O201.OO..OO8.OO4.OO
5.O5.O8.O..O19.OO32.O.OO32.O.OO6.O.OO11.O35.O157.O9.O5.O
4.OO4.OO9.OO22.O16.OO.O11.OO.O30.OO8.OO4.OO8.O.O6.O.O..OO7.OO..O.O6.O.O152.OO3.O9.O5.O
6.OO.O36.O..O12.O.OO45.O9.O5.O9.O.O5.O..O..O9.O..O..O5.O.O153.O..OO8.OO4.OO68.O
6.O.OO102.O9.O5.O9.O7.O.O5.O3.O5.O.O7.O153.O5.OO.O6.OO.O69.O.O
111.OO8.OO4.OO24.OO3.OO168.OO4.O.OO6.O.OO16.O.OO.OO45.O3.O
113.OO.O6.OO.O136.O4.O94.OO.OO..OO21.O.OO.O5.O10.O3.O
113.O.OO6.O.OO12.O..O27.O..O87.3O4.3O92.O25.O.O5.O6.OO8.O3.O
67.O71.4O9.3O3.3O9.4O86.O10.O98.OO17.O7.OO7.O6.O3.O
66.O.O76.O21.O92.OO8.OO91.OO5.OO17.O.O3.O10.OO6.O.O
67.O73.5O6.O.O3.O.O6.5O191.OO27.OO.O10.3O6.O
20.OO11.OO6.O99.O4.OO5.O5.O5.OO4.O199.O34.OO
20.O.O9.O.O6.3O8.OO11.5O72.OO..O19.O..OO86.3O12.3O88.OO..OO.OO
21.O8.3O11.O7.O11.O4.O74.O.O19.O.O96.OO97.OO.OO.O
29.O3.O9.O6.O.O10.O..O77.O.O.OO13.OO.O.O59.OO3.OO..O.OO24.OO
20.OO3.O3.5O9.O3.O..OO8.O..O.OO78.OO.O15.O.OO60.OO3.OO..OO.O
20.OO.3O3.OO17.O10.O.O.O4.OO78.O15.O76.OO9.O9.O6.O9.O117.O.OO.OO
25.O3.5O11.O..O11.O..O3.O..O..OO73.OO3.OO3.OO3.OO63.OO3.OO7.O8.O.O7.O8.O7.O.O115.OO.OO..OO
29.O3.O12.3O14.OO..O.O4.O..O74.O..O.O..O67.O.O.O.O6.O10.O8.O8.O8.O116.O
21.O8.3O35.O5.O.O.O74.OO3.OO70.O.O8.OO18.O8.O132.OO
20.O.O9.O.O7.OO27.OO.O..O151.OO.O6.OO21.O6.O126.OO5.OO
20.OO11.OO6.O.O5.OO20.OO.O158.OO5.O155.OO
41.O7.O18.O4.O160.O4.O22.O6.O109.O24.O
40.OO8.3O15.5O160.O5.OO20.O8.O107.O.O15.OO..OO.OO
52.O180.OO..OO13.O8.O8.O8.O97.O3.O15.OO.OO.O
70.O163.O3.O12.O.O7.O8.O7.O.O97.O3.O
69.O.O161.O3.O14.O9.O6.O9.O99.O3.O
70.O162.OO..OO141.O3.O
175.OO3.OO83.OO114.O.O
113.OO.O6.OO.O47.O..O.O..O82.OO115.O
113.O.OO6.O.OO12.O.O13.O.O12.OO3.OO3.OO3.OO70.3O12.3O
117.OO..OO....OO.............O...........O...............O...............O
117.O...O.....O..........O..O.............O..O........OO.O...............O.OO
118.O3.O5.O8.O.O.O13.O.O.O5.O..O.OO13.OO.O..O68.OO8.OO
117.OO..OO4.OO8.O..O15.O..O5.OO.O19.O.OO68.O10.O
113.OO.O6.OO.O11.OO4.3O3.3O4.OO9.O5.3O3.3O5.O72.3O4.3O
113.O.OO6.O.OO18.O5.O16.OO5.O5.O5.OO74.O4.O
111.OO........OO....OO
6.OO.O10.OO12.OO5.OO16.OO50.O9.O5.O10.OO17.OO9.OO17.OO
6.O.OO11.O12.O7.O16.O52.O9.O5.O8.O..O15.O..O7.O..O15.O..O
4.OO4.OO9.O.O8.O.O7.O.O12.O.O51.OO8.OO4.OO8.O.O..O11.O..O.O7.O.O..O11.O..O.O178.OO
4.O5.O11.OO8.OO9.OO12.OO54.OO.O6.OO.O11.O19.O9.O19.O169.OO7.O.O15.OO
5.O5.O36.O4.O59.O.OO6.O.OO12.OO.O11.O.OO11.OO.O11.O.OO136.OO.O6.OO.O6.OO.O10.OO7.O17.OO
4.OO4.OO13.6O15.OO.4O.OO85.O13.O15.O13.O138.O.OO6.O.OO6.O.OO19.3O
6.OO.O38.O4.O22.OO.OO241.OO8.OO4.OO..OO4.OO
6.O.OO12.OO8.OO9.OO12.OO16.O.O.O242.O9.O5.O3.O5.O33.O
10.OO9.O.O8.O.O7.O.O12.O.O15.O3.O243.O9.O5.O3.O5.O29.OO3.O
10.O10.O12.O7.O16.O13.OO.3O186.O56.OO8.OO4.OO..OO4.OO17.3O9.OO.O.OO
11.O8.OO12.OO5.OO16.OO11.O.O.O186.3O58.OO.O6.OO.O4.O5.O18.O10.O6.OO
10.OO60.O.O.O150.O.OO6.OO.O10.OO9.O61.O.OO6.O.OO5.O5.O17.O.O9.OO.O.OO
6.OO.O60.OO..O152.OO.O6.O.OO11.O9.OO58.OO4.OO8.OO..OO4.OO18.OO9.OO3.O
6.O.OO59.O4.OO149.OO14.OO9.O.O67.O5.O9.O3.O5.O33.O
69.5O152.O14.O11.OO68.O5.O9.O3.O5.O
67.OO4.O..3O146.O16.O79.OO4.OO8.OO..OO4.OO
24.OO40.O..3O3.O3.O7.O25.OO.O6.OO.O20.OO3.OO32.OO3.OO32.OO14.OO15.O65.OO.O6.OO.O6.OO.O
25.O24.OO14.OO.O5.OO.OO5.3O25.O.OO6.O.OO19.O..O.O..O30.O..O.O..O33.O.OO6.OO.O17.O.O63.O.OO6.O.OO6.O.OO
24.O21.OO..O18.O4.O4.O4.O32.OO..OO4.OO13.OO3.OO3.OO3.OO22.OO3.OO3.OO3.OO29.OO.O6.O.OO16.O125.O4.O
23.O.3O18.O.O.O15.3O5.OO.OO5.O.OO29.O3.O5.O14.O15.O22.O15.O33.OO..OO21.O122.OO.4O.OO
23.O.O..O18.O..O.OO12.O7.O3.O3.3O..O30.O3.O5.O10.OO.O15.O.OO16.OO.O15.O.OO31.O..O23.OO3.OO117.O4.O
20.OO.O..OO.O20.O.OO21.3O..O4.OO30.OO..OO4.OO8.O..O.OO13.OO.O..O13.O.O.OO13.OO.O.O29.O4.O27.O.O
21.O.O.O.O.O20.O29.5O28.OO.O6.OO.O10.OO.O19.O.OO13.O.O19.O.O29.OO..OO18.OO9.O
21.O.O.O.O.OO10.OO5.O.O27.OO4.O28.O.OO6.O.OO13.O19.O14.OO..O19.O..OO23.O.OO6.OO.O15.O9.OO
22.O4.O..O10.O.O4.OO29.O..OO27.OO14.OO11.OO5.O5.O5.OO13.O4.OO5.O5.O5.OO4.O22.OO.O6.O.OO12.3O
23.OO3.O13.O3.OO29.O.O.O29.O15.O18.O.O3.O.O19.5O6.O.O3.O.O6.5O48.O
25.3O19.O29.O.O.O30.O15.O49.O21.O
21.3O16.7O28.3O.OO30.OO14.OO17.3O3.3O17.4O9.3O3.3O9.4O
21.O..OO14.O33.O3.O34.OO.O6.OO.O45.O..O27.O..O
24.O.O16.OO29.O.O.O34.O.OO6.O.OO
25.O.................OO............................OO.OO
145..O.......O................O.......O.O...............O.O.......O
145.O.O.....O.O..............O.O.....O..O...............O..O.....O.O
145..O.......O...............O.O......O.O...............O.O......O.O
145...........................O...................................O
.
171.O35.O43.OO25.OO
170.O.O6.O.O15.O.O6.O.O19.O.OO4.OO3.OO9.O25.O
170.O.O5.O..O15.O..O5.O.O19.OO.O4.OO3.OO9.O.O13.O7.O.O
171.O7.O.O15.O.O7.O18.OO25.OO6.O5.O..O5.OO
152.O74.O8.OO3.OO17.OO5.O
77.OO6.OO63.3O73.O9.O.O.O.O16.OO10.O
77.OO6.OO62.O22.O..O27.O..O19.OO10.O.O19.OO4.OO3.O
OO4.OO.O48.OO89.OO21.4O9.3O3.3O9.4O21.O.OO5.OO.O25.5O
.O4.O.OO16.OO.O10.O16.O.O118.O21.O27.OO.O9.OO
O3.OO4.OO13.O..OO10.3O14.O20.O6.O52.O35.5O6.O.O3.O.O6.5O27.OO8.O23.5O
OO..O5.O15.O11.OO3.O10.OO.O14.OO..OO.OO..OO.OO..OO45.O.O4.O29.O4.OO5.O5.O5.OO4.O28.O7.O18.OO4.OO3.O
5.O5.O11.3O.3O7.O3.OO.O9.OO.O14.OO4.O6.O4.OO46.O5.OO6.OO21.OO..O19.O..OO28.O8.OO16.OO10.O
OO..OO4.OO10.O4.O..O.O5.3O.O.O12.O.OO83.O7.OO23.O.O19.O.O30.OO8.O17.OO5.O
.O..O5.O12.3O.O.O.OO12.OO7.OO.O119.O.O.OO13.OO.O.O26.O.OO9.O11.OO6.O5.O..O5.OO
O4.O5.O8.3O4.O.O8.4O5.O6.O.O..O..O115.OO.O15.O.OO27.OO.O9.OO9.O.O13.O7.O.O
OO..OO4.OO8.O..5O.O8.O6.OO.O8.OO.O.O3.OO4.OO4.O6.O4.OO64.OO23.O15.O54.O25.O
4.O5.O12.O4.O10.OO..O..O.O10.O7.O4.OO..OO.OO..OO.OO..OO52.O11.OO5.OO16.OO3.OO3.OO3.OO53.OO25.OO
OO3.O5.O12.4O13.O.O.O..OO9.O.6O11.O6.O52.O5.OO17.O21.O..O.O..O
.O..OO4.OO29.O.O.O.O12.O76.O.O4.O16.O.O22.OO3.OO
O5.OO.O16.OO14.OO.O.O13.O.OO73.O22.OO
OO4.O.OO16.OO18.O13.OO.OO12.OO6.OO
77.OO......OO
.
149...O.....O
149..OOO...OOO
.
.
.
.
149..O.......O
149.O.O.....O.O
149..O.......O
